[Setup]
;-- Main Setup Information
 AppName                  = SQLBackup
 AppVerName               = SQLBackup 1.0.1.2
 AppCopyright             = Copyright  1995-2003 NetWorkDLS.
 DefaultDirName           = {pf}\NetWorkDLS\SQL Backup
 DefaultGroupName         = NetWorkDLS\SQL Backup
 UninstallDisplayIcon     = {app}\SQLBackup.Exe
 UninstallStyle           = Modern
 WizardImageFile          = Resources\LgSetup.bmp
 WizardSmallImageFile     = Resources\SmSetup.bmp
 PrivilegesRequired       = PowerUser
 Uninstallable            = Yes
 AppMutex                 = SQLBackup
 LicenseFile              = Resources\EULA.txt
 Compression              = ZIP/9
 OutputBaseFilename       = Setup
;UninstallLogMode         = OverWrite
 ChangesAssociations      = Yes
 UninstallRestartComputer = Yes
 DirExistsWarning         = No
 UserInfoPage             = Yes

;-- Windows 2000 & XP (Support Dialog)
 AppPublisher    = NetWorkDLS
 AppPublisherURL = http://www.NetWorkDLS.com/
 AppUpdatesURL   = http://www.NetWorkDLS.com/
 AppVersion      = 1.0.1.2

[Files]
 Source: "..\Debug\SQLBackup.Exe";            DestDir: "{app}"; Flags: IgnoreVersion RestartReplace;
 Source: "SQLService\Release\SQLService.Exe"; DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "SBFInfo\Release\SBFInfo.Exe";       DestDir: "{app}"; Flags: IgnoreVersion;
;Source: "KeySecure\Release\KeySecure.Exe";   DestDir: "{app}"; Flags: IgnoreVersion;

 Source: "Resources\EULA.txt";                DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Help\SQLBackup.chm";                DestDir: "{app}"; Flags: IgnoreVersion;
 
 Source: "Resources\Schedule.ndbs";           DestDir: "{app}\NDBS"; Flags: OnlyIfDoesntExist RestartReplace;
 Source: "Resources\JobLog.ndbs";             DestDir: "{app}\NDBS"; Flags: OnlyIfDoesntExist RestartReplace;

 Source: "Libraries\NSWFL.Dll";               DestDir: "{app}"; Flags: RestartReplace;
 Source: "Libraries\NASCCL.Dll";              DestDir: "{app}"; Flags: RestartReplace;
 Source: "Libraries\NDBS.Dll";                DestDir: "{app}"; Flags: RestartReplace;

[Tasks]
 Name: RegisterService;     Description: "Register as service";     GroupDescription: "Windows NT Service:"; MinVersion: 0, 4.0;
 Name: StartService;        Description: "Start the service ";      GroupDescription: "Windows NT Service:"; MinVersion: 0, 4.0;
 Name: RunAtStartup;        Description: "&Run at startup";         GroupDescription: "Windows Options:";    MinVersion: 4.0, 0;

[Icons]
 Name: "{group}\SQLBackup";       Filename: "{app}\SQLBackup.EXE"; WorkingDir: "{app}"; MinVersion: 4.0, 0;
 Name: "{userstartup}\SQLBackup"; Filename: "{app}\SQLBackup.EXE"; WorkingDir: "{app}"; MinVersion: 4.0, 0; Tasks: RunAtStartup;
;Name: "{group}\Key Security";    Filename: "{app}\KeySecure.Exe";
 Name: "{group}\Help";            Filename: "{app}\SQLBackup.chm";
;Name: "{group}\SBF Info";        Filename: "{app}\SBFInfo.Exe";
 Name: "{group}\Uninstall";       Filename: "{uninstallexe}";

[Dirs]
 Name: "{app}\Data"
 Name: "{app}\NDBS"

[Registry]
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "Path";             ValueType: String; ValueData: "{app}";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "HelpPath";         ValueType: String; ValueData: "{app}\SQLBackup.chm";

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "OwnerName";        ValueType: String; ValueData: "{userinfoname}";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "OwnerOrg";         ValueType: String; ValueData: "{userinfoorg}";

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "UserKey";          ValueType: String; ValueData: "s2se5iKi42VghyD1ytMRyVVhRWi1XCPdVpUFoyGYxLthgnSrtugQdouE577Bwg3VwNkGbelg8TTbjvHxRFOHNh2TEEC61X7dwOx8xs6uQopslv8tRkSrWQUKY6TG5XR3";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "JobLogDB";         ValueType: String; ValueData: "{app}\NDBS\JobLog.ndbs";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "CodedKeysDB";      ValueType: String; ValueData: "{app}\NDBS\CodedKeys.ndbs";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "ScheduleDB";       ValueType: String; ValueData: "{app}\NDBS\Schedule.ndbs";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "AllOnHold";        ValueType: Dword;  ValueData: "0";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "SavePassword";     ValueType: Dword;  ValueData: "0";

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterDatabase";   ValueType: String; ValueData: "Master";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterDriver";     ValueType: String; ValueData: "{{SQL Server}";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterPWS";        ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterServer";     ValueType: String; ValueData: "(Local)";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterUID";        ValueType: String; ValueData: "sa";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterTrusted";    ValueType: Dword;  ValueData: "1"; MinVersion: 0, 4.0
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "MasterTrusted";    ValueType: Dword;  ValueData: "0"; MinVersion: 4.0, 0
 
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupFile";       ValueType: String; ValueData: "{app}\Data\SQLBackup.sbf";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupDataBase";   ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupUserID";     ValueType: String; ValueData: "sa";
;Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupUserPW";     ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupServer";     ValueType: String; ValueData: "(Local)";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupDriver";     ValueType: String; ValueData: "{{SQL Server}";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupTrusted";    ValueType: Dword;  ValueData: "1"; MinVersion: 0, 4.0
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "BackupTrusted";    ValueType: Dword;  ValueData: "0"; MinVersion: 4.0, 0

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreFile";      ValueType: String; ValueData: "{app}\Data\SQLRestore.sbf";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreDataBase";  ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreUserID";    ValueType: String; ValueData: "sa";
;Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreUserPW";    ValueType: String; ValueData: "";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreServer";    ValueType: String; ValueData: "(Local)";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreDriver";    ValueType: String; ValueData: "{{SQL Server}";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreTrusted";   ValueType: Dword;  ValueData: "1"; MinVersion: 0, 4.0
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQLBackup"; ValueName: "RestoreTrusted";   ValueType: Dword;  ValueData: "0"; MinVersion: 4.0, 0

 Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\Setup"; ValueName: "SBED"; ValueType: Dword;  ValueData: "0";

;-- Create SBF Info Viewer File Assocation
 Root: HKCR; Subkey: ".sbf"; Flags: UninsDeleteKey
 Root: HKCR; Subkey: ".Sbf"; ValueType: String; ValueData: "sbffile";

 Root: HKCR; Subkey: "sbffile\DefaultIcon";        ValueType: String; ValueData: """{app}\SBFInfo.Exe"",0";
 Root: HKCR; Subkey: "sbffile\Shell";              ValueType: String; ValueData: "View";
 Root: HKCR; Subkey: "sbffile\Shell\View";         ValueType: String; ValueData: "View Information";
 Root: HKCR; Subkey: "sbffile\Shell\View\Command"; ValueType: String; ValueData: """{app}\SBFInfo.Exe"" %1";

[Run]
 Filename: "{app}\SQLService.EXE"; Parameters: "/install"; Tasks: RegisterService;    MinVersion: 0, 4.0
 Filename: "{app}\SQLService.EXE"; Parameters: "/start";   Tasks: StartService;       MinVersion: 0, 4.0

[UninstallRun]
 Filename: "{app}\SQLService.EXE"; Parameters: "/delete"; RunOnceId: "DeleteService"; MinVersion: 0, 4.0

